(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* ::Code:: *)
Int[u_^m_.,x_Symbol] :=
  Module[{c=Simplify[D[u,x]]},
  1/c*Subst[Int[x^m,x],x,u]] /;
FreeQ[m,x] && PiecewiseLinearQ[u,x]


(* ::Code:: *)
Int[v_/u_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  b*x/a - (b*u-a*v)/a*Int[1/u,x] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x]


(* ::Code:: *)
Int[v_^n_/u_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  v^n/(a*n) - (b*u-a*v)/a*Int[v^(n-1)/u,x] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x] && RationalQ[n] && n>0 && n!=1


(* ::Code:: *)
Int[1/(u_*v_),x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  b/(b*u-a*v)*Int[1/v,x] - a/(b*u-a*v)*Int[1/u,x] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x]


(* ::Code:: *)
Int[1/(u_*Sqrt[v_]),x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  2*ArcTan[Sqrt[v]/Rt[(b*u-a*v)/a,2]]/(a*Rt[(b*u-a*v)/a,2]) /;
 NeQ[b*u-a*v] && PosQ[(b*u-a*v)/a]] /;
PiecewiseLinearQ[u,v,x]


(* ::Code:: *)
Int[1/(u_*Sqrt[v_]),x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  -2*ArcTanh[Sqrt[v]/Rt[-(b*u-a*v)/a,2]]/(a*Rt[-(b*u-a*v)/a,2]) /;
 NeQ[b*u-a*v] && NegQ[(b*u-a*v)/a]] /;
PiecewiseLinearQ[u,v,x]


(* ::Code:: *)
Int[v_^n_/u_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  v^(n+1)/((n+1)*(b*u-a*v)) - 
  a*(n+1)/((n+1)*(b*u-a*v))*Int[v^(n+1)/u,x] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x] && RationalQ[n] && n<-1


(* ::Code:: *)
Int[v_^n_/u_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  v^(n+1)/((n+1)*(b*u-a*v))*Hypergeometric2F1[1,n+1,n+2,-a*v/(b*u-a*v)] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x] && Not[IntegerQ[n]]


(* ::Code:: *)
Int[1/(Sqrt[u_]*Sqrt[v_]),x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  2/Rt[a*b,2]*ArcTanh[Rt[a*b,2]*Sqrt[u]/(a*Sqrt[v])] /;
 NeQ[b*u-a*v] && PosQ[a*b]] /;
PiecewiseLinearQ[u,v,x]


(* ::Code:: *)
Int[1/(Sqrt[u_]*Sqrt[v_]),x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  2/Rt[-a*b,2]*ArcTan[Rt[-a*b,2]*Sqrt[u]/(a*Sqrt[v])] /;
 NeQ[b*u-a*v] && NegQ[a*b]] /;
PiecewiseLinearQ[u,v,x]


(* ::Code:: *)
Int[u_^m_*v_^n_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  -u^(m+1)*v^(n+1)/((m+1)*(b*u-a*v)) /;
 NeQ[b*u-a*v]] /;
FreeQ[{m,n},x] && PiecewiseLinearQ[u,v,x] && EqQ[m+n+2] && NeQ[m+1]


(* ::Code:: *)
Int[u_^m_*v_^n_.,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  u^(m+1)*v^n/(a*(m+1)) - 
  b*n/(a*(m+1))*Int[u^(m+1)*v^(n-1),x] /;
 NeQ[b*u-a*v]] /;
FreeQ[{m,n},x] && PiecewiseLinearQ[u,v,x] (* && NeQ[m+n+2] *) && NeQ[m+1] && (
  RationalQ[m,n] && m<-1 && n>0 && Not[IntegerQ[m+n] && m+n+2<0 && (FractionQ[m] || 2*n+m+1>=0)] || 
  PositiveIntegerQ[n,m] && n<=m ||
(*NegativeIntegerQ[n,m] && n<=m || *)
  PositiveIntegerQ[n] && Not[IntegerQ[m]] ||
  NegativeIntegerQ[m] && Not[IntegerQ[n]])


(* ::Code:: *)
Int[u_^m_*v_^n_.,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  u^(m+1)*v^n/(a*(m+n+1)) - 
  n*(b*u-a*v)/(a*(m+n+1))*Int[u^m*v^(n-1),x] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x] && NeQ[m+n+2] && RationalQ[n] && n>0 && NeQ[m+n+1] && 
  Not[PositiveIntegerQ[m] && (Not[IntegerQ[n]] || 0<m<n)] && 
  Not[IntegerQ[m+n] && m+n+2<0]


(* ::Code:: *)
Int[u_^m_*v_^n_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  u^(m+1)*v^n/(a*(m+n+1)) - 
  n*(b*u-a*v)/(a*(m+n+1))*Int[u^m*v^Simplify[n-1],x] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x] && NeQ[m+n+1] && Not[RationalQ[n]] && SumSimplerQ[n,-1]


(* ::Code:: *)
Int[u_^m_*v_^n_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  -u^(m+1)*v^(n+1)/((m+1)*(b*u-a*v)) + 
  b*(m+n+2)/((m+1)*(b*u-a*v))*Int[u^(m+1)*v^n,x] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x] && NeQ[m+n+2] && RationalQ[m] && m<-1


(* ::Code:: *)
Int[u_^m_*v_^n_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  -u^(m+1)*v^(n+1)/((m+1)*(b*u-a*v)) + 
  b*(m+n+2)/((m+1)*(b*u-a*v))*Int[u^Simplify[m+1]*v^n,x] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x] && Not[RationalQ[m]] && SumSimplerQ[m,1]


(* ::Code:: *)
Int[u_^m_*v_^n_,x_Symbol] :=
  Module[{a=Simplify[D[u,x]],b=Simplify[D[v,x]]},
  u^m*v^(n+1)/(b*(n+1)*(b*u/(b*u-a*v))^m)*Hypergeometric2F1[-m,n+1,n+2,-a*v/(b*u-a*v)] /;
 NeQ[b*u-a*v]] /;
PiecewiseLinearQ[u,v,x] && Not[IntegerQ[m]] && Not[IntegerQ[n]]


(* ::Code:: *)
Int[u_^n_.*Log[a_.+b_.*x_],x_Symbol] :=
  Module[{c=Simplify[D[u,x]]},
  u^n*(a+b*x)*Log[a+b*x]/b - 
  Int[u^n,x] - 
  c*n/b*Int[u^(n-1)*(a+b*x)*Log[a+b*x],x]] /;
FreeQ[{a,b},x] && PiecewiseLinearQ[u,x] && Not[LinearQ[u,x]] && RationalQ[n] && n>0


(* ::Code:: *)
(* Int[u_^n_.*Log[a_.+b_.*x_]/(a_.+b_.*x_),x_Symbol] :=
  Module[{c=Simplify[D[u,x]]},
  u^n*Log[a+b*x]^2/(2*b) - 
  c*n/(2*b)*Int[u^(n-1)*Log[a+b*x]^2,x]] /;
FreeQ[{a,b},x] && PiecewiseLinearQ[u,x] && RationalQ[n] && n>0 *)


(* ::Code:: *)
Int[u_^n_.*(a_.+b_.*x_)^m_.*Log[a_.+b_.*x_],x_Symbol] :=
  Module[{c=Simplify[D[u,x]]},
  u^n*(a+b*x)^(m+1)*Log[a+b*x]/(b*(m+1)) - 
  1/(m+1)*Int[u^n*(a+b*x)^m,x] - 
  c*n/(b*(m+1))*Int[u^(n-1)*(a+b*x)^(m+1)*Log[a+b*x],x]] /;
FreeQ[{a,b,m},x] && PiecewiseLinearQ[u,x] && Not[LinearQ[u,x]] && RationalQ[n] && n>0 && NeQ[m+1]



